/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Definition file of the System device class

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------

    2006-06-28  initial version

**************************************************************************************/
#pragma once

///////////////////////////////////////////////////////////////////////////////////////////
/// \file CifXDeviceSys.h
///  Definition file of the System device class
///////////////////////////////////////////////////////////////////////////////////////////

#include "cifxdevicebase.h"
#include "cifXAPIlib.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// System device class
///////////////////////////////////////////////////////////////////////////////////////////
class CCifXDeviceSys : public CCifXDeviceBase
{
public:
  CCifXDeviceSys(BOARD_INFORMATION* ptBoardInfo, CHANNEL_INFORMATION* ptChannelInfo, CCifXAPIlib* pcCifXAPI);
  virtual ~CCifXDeviceSys(void);

  virtual bool                             IsSystemDevice(void);
  virtual int32_t                          OpenDevice(void);
  virtual int32_t                          CloseDevice(void);
  virtual int32_t                          PutPacket(CIFX_PACKET* ptPacket, uint32_t ulTimeout);
  virtual int32_t                          GetPacket(CIFX_PACKET* ptPacket, uint32_t ulBufferSize, uint32_t ulTimeout);
  virtual CCifXDeviceBase::PROPERTY_VECTOR GetChannelInformation(uint32_t ulCmd);
  virtual CString                          GetChannelInfoName(void);
  virtual int32_t                          GetMBXState(uint32_t* pulRecvCount, uint32_t* pulSendCount);
  virtual int32_t                          Reset(uint32_t ulMode, uint32_t ulTimeout, uint32_t ulResetParam);
  virtual int32_t                          Upload(char* szFilename, uint32_t ulChannel, unsigned char* pbBuffer, uint32_t* pulFileSize);
  
  virtual int32_t Download(uint32_t ulChannel, uint32_t ulMode, char* szFileName, 
                        unsigned char* pabFileData, uint32_t ulFileSize, 
                        PFN_PROGRESS_CALLBACK pfnCallback, void* pvUser);

  virtual int32_t FindFirstFile(uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo);
  virtual int32_t FindNextFile(uint32_t ulChannel, CIFX_DIRECTORYENTRY* ptDirectoryInfo);

/////////////////////////////////////////////////////////////////////////////
  /// Overridden function for channel number. The System device does not own one, so return 0
  ///   \return 0
  /////////////////////////////////////////////////////////////////////////////
  virtual uint32_t GetChannelNr(void) { return 0; }
  virtual uint32_t GetMailboxSize(void);

protected:
  HANDLE m_hSysChannel;   //!< cifX driver Handle to the system channel

  int32_t GetSystemInfoBlock(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemInformation(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemChannelBlock(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemControlBlock(PROPERTY_VECTOR& cvRet);
  int32_t GetSystemStatusBlock(PROPERTY_VECTOR& cvRet);

};
